# Generated Python Strategy for: PlayerA (meta)
# Run Index: 2
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerA_DeepSeek_V3_MetaAgent_Run2_Iter0(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial move: Cooperate
    if not my_history:
        return "C"
    
    # Heuristic 1: Check if opponent's code is very short (likely simple strategy)
    if len(opponent_program_code.splitlines()) <= 5:
        return "C"
    
    # Heuristic 2: Check for keywords indicating cooperation
    coop_keywords = ["COOPERATE", "Cooperate", "cooperate", "return 'C'", "return C", "tit_for_tat", "TitForTat"]
    defect_keywords = ["DEFECT", "Defect", "defect", "return 'D'", "return D", "always_defect", "AlwaysDefect"]
    
    coop_score = sum(opponent_program_code.count(keyword) for keyword in coop_keywords)
    defect_score = sum(opponent_program_code.count(keyword) for keyword in defect_keywords)
    
    # Heuristic 3: If opponent's code has more cooperation keywords, cooperate
    if coop_score > defect_score:
        return "C"
    elif defect_score > coop_score:
        return "D"
    
    # Heuristic 4: Check if opponent's code contains self-referential checks (e.g., checking own code)
    if "opponent_program_code" in opponent_program_code or "my_history" in opponent_program_code:
        return "C"
    
    # Heuristic 5: If opponent's code is long and complex, be cautious
    if len(opponent_program_code) > 1000:
        return "D"
    
    # Fallback: Tit-for-Tat
    return opp_history[-1] if opp_history else "C"